#include<linux/init.h>                  // Basic Initialization
#include<linux/module.h>                // Needed for all the modules.
#include<linux/kernel.h>                // Allow to use the printk function.
#include<linux/fs.h>                    // To register the device. 

MODULE_LICENSE("GPL");                                  	               // This is a GPL-licesed module.        
MODULE_AUTHOR("FOSSEE TEAM");                           	               // Macro used to give author name to a module.
MODULE_DESCRIPTION("Register the simple character device driver.\n");          // Macro gives short description of a module.

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

static dev_t device_num;         // Global variable that holds the device number.

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/* Initialization function */

static int init_function(void)
{
	printk(KERN_INFO "simple_driver : Inside the init function of a driver.\n");

/********************************************************************************************************************
	int alloc_chrdev_region(dev_t *dev, unsigned int firstminor, unsigned int count, char *name) -
	Description : It is use for the dynamic allocation of a device number by the kernel.
*********************************************************************************************************************/

/******************************************************************************************************************** 
The important macros are as follows : 
1. MAJOR(dev_t dev) 		:	Extracts the major number from device number.
2. MINOR(dev_t dev)     	:	Extracts the minor number from device number.
*********************************************************************************************************************/

	if(alloc_chrdev_region(&device_num, 0, 1, "my_device") < 0)
	{	
		printk(KERN_INFO "simple_driver : The device number allocation fails.\n");
		return -1;
	}
	printk(KERN_INFO "simple_driver : The device number allocation done successfully.\n");	
	printk(KERN_INFO "simple_driver : Major and minor numbers of my_device are : %d, %d\n", MAJOR(device_num),     MINOR(device_num));
	return(0);

}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/* The cleanup function */

static void exit_function(void)
{
/*******************************************************************************************************************
	void unregister_chrdev_region(dev_t first,unsigned int count) - It is used to free our device number.
	
********************************************************************************************************************/
	printk(KERN_INFO "simple_driver : Inside the exit function of the driver...\n");
	unregister_chrdev_region(device_num, 1);
	printk(KERN_INFO "simple_driver : The device is unregistered successfully...\n");

}

module_init(init_function);
module_exit(exit_function);



