#include<linux/init.h>            /* Needed for the macros */
#include<linux/module.h>          /* Needed by all modules */
#include<linux/kernel.h>          /* Needed for KERN_INFO  */ 
#include<linux/moduleparam.h>     /* Needed for the macros */


MODULE_LICENSE("GPL");
MODULE_AUTHOR("FOSSEE TEAM");
MODULE_DESCRIPTION("You can pass parameters to this module.\n");

int nvalue, array_value[4], i, value;

/* module_param(name, type, permission) - macro used to pass the variable to a module.
type bool,int,short,uint,ulong.ushort,char* 
*/
module_param(nvalue, int, S_IRUSR | S_IWUSR);

//module_param_array(name, type, nump, permission) - macro used to pass the array elements to a module.
module_param_array(array_value, int, NULL, S_IRUSR | S_IWUSR);

//module_param_named(name, variable, type, permission) - macro is used to have the internal variable named differenty than the external parameter.
module_param_named(name, value, int, S_IRUSR | S_IWUSR);

static int init_func(void)    // Initialization function of a module.
{

	printk(KERN_INFO "my_module : Welcome to a module to which you can pass parameters\n");
	printk(KERN_INFO "my_module : the nvalue is %d.\n",nvalue);
	printk(KERN_INFO "my_module : internal variable value is %d.\n",value);

	printk(KERN_INFO "my_module : The array elements are as follows:\n");
		for(i=0; i<sizeof(array_value) / sizeof(int); i++)
		printk(KERN_INFO "my_module : The array_value[%d] = %d.\n",i,array_value[i]);
	return(0);
}

static void exit_func(void)        //Cleanup function of a module.
{
	printk(KERN_INFO "my_module : Existing from a module to which you passes parameters.\n");

}

module_init(init_func);
module_exit(exit_func);











